CREATE TABLE BEXIgnore (_rowid longlong PRIMARY KEY NOT NULL, foreignAppEntityName char, foreignAppImportID char, foreignAppName char);
CREATE TABLE Category (_rowid longlong PRIMARY KEY NOT NULL, name char);
CREATE TABLE Client (mileageDistance double, _rowid longlong PRIMARY KEY NOT NULL, clientNumber char, company char, createDate datetime, email char, extra1 char, extra2 char, extra3 char, extra4 char, firstName char, hourlyRate double, isCompany boolean, lastName char, mileageRate double, modifyDate datetime, clientCategoryID int, balanceCached double, retainersBalanceCached double, unbilledAmountCached double, incompleteAmountCached double, addressCity char, addressStreet char, addressState char, addressZIP char, addressCountry char, addressFormatted char, clientPhotoID longlong, currentCurrencyID longlong, overdueAmountCached double, overdueAmountValidUntilDate datetime, consolidatedTaxID longlong, invoiceTemplatePrefID longlong, estimateTemplatePrefID longlong, statementTemplatePrefID longlong, taxNumber char, billingIdentityID longlong, prefix char, suffix char, middleName char, nickName char, jobTitle char, department char, formalGreeting char);
CREATE INDEX Client_clientCategoryID_index ON Client (clientCategoryID);
CREATE TABLE ConsolidatedTax (active boolean, atomic boolean, _rowid longlong PRIMARY KEY NOT NULL, createDate datetime, name char, parentConsolidatedTaxID int);
CREATE INDEX ConsolidatedTax_parentConsolidatedTaxID_index ON ConsolidatedTax (parentConsolidatedTaxID);
CREATE TABLE Estimate (billingsFileID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, dueDate datetime, _rowid longlong PRIMARY KEY NOT NULL, estimateNumber char, markup double, modifyDate datetime, name char, projectID int, sentDate datetime, state int, subTotal double, tax1 double, tax1Name char, tax2 double, tax2Name char, useTax1 boolean, useTax2 boolean, userFileID int, estimateHtmlID longlong);
CREATE INDEX Estimate_projectID_index ON Estimate (projectID);
CREATE TABLE EstimateSlip (categoryID int, userID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, distance double, dueDate datetime, duration double, endDateTime datetime, estimateID int, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, markup double, mileageType int, modifyDate datetime, name char, nature int, projectID int, rate double, roundTime int, startDateTime datetime, tax1 double, tax1Name char, tax2 double, tax2Name char, _rowid longlong PRIMARY KEY NOT NULL, timeSlipRefID int, total double, typeID int, units double, useTax1 boolean, useTax2 boolean, uuid char);
CREATE INDEX EstimateSlip_estimateID_index ON EstimateSlip (estimateID);
CREATE INDEX EstimateSlip_projectID_index ON EstimateSlip (projectID);
CREATE TABLE ExtraFieldNames (extraField1Name char, extraField2Name char, extraField3Name char, extraField4Name char, extraField5Name char, extraField6Name char, extraField7Name char, extraField8Name char, _rowid longlong PRIMARY KEY NOT NULL, forEntity integer);
CREATE TABLE Invoice (billingsFileID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, dueDate datetime, invoiceDate datetime, _rowid longlong PRIMARY KEY NOT NULL, invoiceNumber char, markup double, modifyDate datetime, name char, sentDate datetime, state int, tax1 double, tax1Name char, tax2 double, tax2Name char, taxPointDate datetime, useTax1 boolean, useTax2 boolean, userFileID int, clientID int, projectID int, invoiceHtmlID longlong, totalCached double);
CREATE INDEX Invoice_clientID_index ON Invoice (clientID);
CREATE TABLE Note (contents object, createDate datetime, modifyDate datetime, name char, _rowid longlong PRIMARY KEY NOT NULL, plainContents char, projectID int);
CREATE INDEX Note_projectID_index ON Note (projectID);
CREATE TABLE Payment (cachedAppliedAmount double, comment char, createDate datetime, methodID int, modifyDate datetime, name char, _rowid longlong PRIMARY KEY NOT NULL, projectID int, total double, clientID int, baseCurrencyTotal double, baseCurrencyManuallyEntered int);
CREATE INDEX Payment_clientID_index ON Payment (clientID);
CREATE TABLE PaymentInvoiceEntry (amountApplied double, createDate datetime, _rowid longlong PRIMARY KEY NOT NULL, invoiceID int, modifyDate datetime, paymentID int);
CREATE INDEX PaymentInvoiceEntry_invoiceID_index ON PaymentInvoiceEntry (invoiceID);
CREATE INDEX PaymentInvoiceEntry_paymentID_index ON PaymentInvoiceEntry (paymentID);
CREATE TABLE PaymentMethodType (name char, _rowid longlong PRIMARY KEY NOT NULL, useRetainer boolean);
CREATE TABLE Project (balance double, clientID int, completeDate datetime, createDate datetime, discount double, dueDate datetime, extraField1 char, extraField2 char, extraField3 char, extraField4 char, extraField5 char, extraField6 char, extraField7 char, extraField8 char, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, modifyDate datetime, name char, nickname char, objective char, poNumber char, projectCode char, _rowid longlong PRIMARY KEY NOT NULL, stageID int, startDate datetime, stateID int, total double, useNickname boolean, uuid char, totalCached double, unbilledCached double, incompleteCached double, estimatePendingCached double, durationOfSlipsCached long, approverID longlong);
CREATE INDEX Project_clientID_index ON Project (clientID);
CREATE TABLE ProjectStage (name char, _rowid longlong PRIMARY KEY NOT NULL);
CREATE TABLE ProjectState (name char, stateCode int, _rowid longlong PRIMARY KEY NOT NULL);
CREATE TABLE Retainer (amountApplied double, createDate datetime, modifyDate datetime, name char, projectID int, _rowid longlong PRIMARY KEY NOT NULL, total double, clientID int, comment char, methodID int, baseCurrencyTotal double, baseCurrencyManuallyEntered boolean);
CREATE INDEX Retainer_clientID_index ON Retainer (clientID);
CREATE TABLE SlipTemplate (categoryID int, userID int, comment char, consolidatedTaxID int, discount double, markup double, name char, nature int, rate double, slipName char, _rowid longlong PRIMARY KEY NOT NULL, typeID int, units double, useTax1 boolean, useTax2 boolean, recurringInvoiceID int);
CREATE TABLE Tax (active boolean, compound boolean, consolidatedTaxID int, createDate datetime, name char, orderIndex int, parentTaxID int, rate double, registrationNum char, _rowid longlong PRIMARY KEY NOT NULL);
CREATE INDEX Tax_consolidatedTaxID_index ON Tax (consolidatedTaxID);
CREATE INDEX Tax_parentTaxID_index ON Tax (parentTaxID);
CREATE TABLE TaxConsolidatedTaxEntry (consolidatedTaxID int, orderIndex int, _rowid longlong PRIMARY KEY NOT NULL, taxID int);
CREATE INDEX TaxConsolidatedTaxEntry_consolidatedTaxID_index ON TaxConsolidatedTaxEntry (consolidatedTaxID);
CREATE INDEX TaxConsolidatedTaxEntry_taxID_index ON TaxConsolidatedTaxEntry (taxID);
CREATE TABLE TimeEntry (comment char, createDate datetime, endDateTime datetime, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, isManual boolean, modifyDate datetime, startDateTime datetime, _rowid longlong PRIMARY KEY NOT NULL, timeSlipID int, uuid char);
CREATE INDEX TimeEntry_endDateTime_index ON TimeEntry (endDateTime);
CREATE INDEX TimeEntry_startDateTime_index ON TimeEntry (startDateTime);
CREATE INDEX TimeEntry_timeSlipID_index ON TimeEntry (timeSlipID);
CREATE TABLE TimeSlip (activeForTiming int, categoryID int, userID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, distance double, dueDate datetime, duration double, endDateTime datetime, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, iCalUID char, invoiceID int, invoicedDate datetime, markup double, mileageType int, modifyDate datetime, name char, nature int, projectID int, rate double, roundTime boolean, startDateTime datetime, tax1 double, tax1Name char, tax2 double, tax2Name char, _rowid longlong PRIMARY KEY NOT NULL, timeSlipRefID int, total double, typeID int, units double, useTax1 boolean, useTax2 boolean, uuid char, invoicedProjectID int, totalCached double, durationCached long, geoLocationStart char, geoLocationEnd char, workflowState int DEFAULT '0', approvedByUserID longlong, approvedDate datetime, extra1 char, extra2 char, extra3 char, extra4 char);
CREATE INDEX TimeSlip_invoiceID_index ON TimeSlip (invoiceID);
CREATE INDEX TimeSlip_projectID_index ON TimeSlip (projectID);
CREATE INDEX TimeSlip_invoicedProjectID_index ON TimeSlip (invoicedProjectID);
CREATE TABLE TimeSlipType (typeCode int, _rowid longlong PRIMARY KEY NOT NULL);
CREATE TABLE URLReference (createDate datetime, kind int, modifyDate datetime, name char, projectID int, url object, _rowid longlong PRIMARY KEY NOT NULL, urlType int);
CREATE INDEX URLReference_projectID_index ON URLReference (projectID);
CREATE TABLE User (createDate datetime, name char, modifyDate datetime, _rowid longlong PRIMARY KEY NOT NULL, active boolean NOT NULL DEFAULT '0', password char, canUseBillingsPro boolean, canUseBillingsProTouch boolean, canUsePunchcard boolean, capability4 boolean, capability5 boolean, capability6 boolean, capability7 boolean, capability8 boolean);
CREATE TABLE MCUserDefaultsStorage (BlobValue object, HostID char, Key char, LastType int, _rowid longlong PRIMARY KEY NOT NULL, Value char);
CREATE TABLE Statement (_rowid longlong PRIMARY KEY NOT NULL, clientID int, billingsFileID int, userFileID int, sentDate datetime, comment char, fromDate datetime, toDate datetime, totalBalance double, currentDue double, overdue30Days double, overdue60Days double, overdue90Days double, overdueOver90Days double, statementNumber char);
CREATE INDEX Statement_clientID_index ON Statement (clientID);
CREATE TABLE ClientCategory (_rowid longlong PRIMARY KEY NOT NULL, name char, collapsed boolean, orderNumber int);
CREATE TABLE RecurringInvoice (_rowid longlong PRIMARY KEY NOT NULL, clientID int, lastSentDate datetime, nextSendDate datetime, modifyDate datetime, recurMonths int, recurDay int, templatePath char, name char, lastPlannedSendDate datetime, includeUnbilled boolean);
CREATE INDEX RecurringInvoice_clientID_index ON RecurringInvoice (clientID);
CREATE TABLE ProFormaInvoice (billingsFileID int, comment char, createDate datetime, dueDate datetime, invoiceDate datetime, modifyDate datetime, _rowid longlong PRIMARY KEY NOT NULL, clientID int, userFileID int, name char, slipList char, templatePath char, total double, retainerAmountApplied double, customizationValues char, templatePreferenceID longlong);
CREATE INDEX ProFormaInvoice_clientID_index ON ProFormaInvoice (clientID);
CREATE TABLE ClientABLink (_rowid longlong PRIMARY KEY NOT NULL, clientID longlong, deviceUUID char, abUUID char, abAddressUUID char, abEmailUUID char);
CREATE INDEX ClientABLink_clientID_index ON ClientABLink (clientID);
CREATE INDEX ClientABLink_deviceUUID_index ON ClientABLink (deviceUUID);
CREATE INDEX ClientABLink_abUUID_index ON ClientABLink (abUUID);
CREATE TABLE ClientPhoto (_rowid longlong PRIMARY KEY NOT NULL, imageData object);
CREATE TABLE SlipConflict (_rowid longlong PRIMARY KEY NOT NULL, originalSlipID longlong, duplicateSlipID longlong);
CREATE TABLE DatabaseConfiguration (_rowid longlong PRIMARY KEY NOT NULL, schemaNumber int, databaseUUID char, databaseType int NOT NULL DEFAULT '0', primaryKeyOffset int NOT NULL, lastUsedReplicationOffset int NOT NULL DEFAULT '0');
CREATE TABLE InvoiceHtml (_rowid longlong PRIMARY KEY NOT NULL, html char, type int);
CREATE TABLE Currency (_rowid longlong PRIMARY KEY NOT NULL, name char, currencyCode char, currencySymbol char, exchangeRateToBase float DEFAULT '1', exchangeRateDate datetime, isBaseCurrency boolean DEFAULT '0', active boolean DEFAULT '1', localeIdentifier char, overrideLocaleIdentifier char, extra1 char, extra2 char, extra3 char, extra4 char);
CREATE TABLE EstimateHtml (_rowid longlong PRIMARY KEY NOT NULL, html char, type int);
CREATE TABLE Extra (_rowid longlong PRIMARY KEY NOT NULL, mimeType char, mimeSubtype char, internalType int, name char, dataValue object, stringValue char, datetimeValue datetime, doubleValue double, floatValue float, intValue int, parentEntity char, parentID longlong);
CREATE TABLE ReportTemplate (_rowid longlong PRIMARY KEY NOT NULL, templateData object, name char, behaviors char, createDate datetime, entityName char, modifyDate datetime, isActiveCode boolean, version int, thumbnailData object, thumbnailType char);
CREATE TABLE ProjectUser (_rowid longlong PRIMARY KEY NOT NULL, userID longlong NOT NULL, projectID longlong NOT NULL, createDate datetime, modifyDate datetime, hourlyRate double, mileageRate double);
CREATE TABLE EO_PK (_rowid longlong PRIMARY KEY NOT NULL, tableName char, nextPKey longlong);
CREATE TABLE ReportTemplatePreference (_rowid longlong PRIMARY KEY NOT NULL, templateName char, reportTemplateID longlong, configuration object);
CREATE TABLE Identity (_rowid longlong PRIMARY KEY NOT NULL, logo object, logoType char, line1 char, line2 char, line3 char, line4 char, bankAccount char, bankIdentifier char, bankName char, bankAddress char, IBAN char, BIC char, extra1 char, extra2 char, extra3 char, extra4 char);
